(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27515,       1065]*)
(*NotebookOutlinePosition[     28355,       1092]*)
(*  CellTagsIndexPosition[     28311,       1088]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->16],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontSize->34,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{0, 0}, {0, 0}},
  LineSpacing->{1, 0},
  FontSize->44],

Cell[StyleData["Title", "Condensed"],
  CellMargins->{{0, 0}, {0, 0}},
  FontSize->20],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  FontSize->24,
  FontTracking->"Plain",
  Background->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  LineSpacing->{1, 3},
  ParagraphIndent->-96,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.700008, 0.700008]],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{0, 0}, {0, 0}},
  LineSpacing->{1, 6},
  ParagraphIndent->-157,
  FontSize->30],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{0, 0}, {0, 0}},
  ParagraphIndent->-78,
  FontSize->14],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  ParagraphIndent->-85,
  FontSize->16,
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {30, 10}},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{8, 10}, {40, 20}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {12, 8}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{6, 0}, {0, 1}},
  CellDingbat->None,
  CellMargins->{{12, Inherited}, {4, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->6,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{10, 10}, {8, 32}},
  LineSpacing->{1, 2},
  FontSize->24,
  FontTracking->"Condensed"],

Cell[StyleData["Section", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{12, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{11, 10}, {8, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {4, 40}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{25, Inherited}, {8, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{29, 10}, {8, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{22, Inherited}, {2, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{21, 0}, {4, 20}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {5, 5}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  CounterIncrements->"Text",
  FontFamily->"Times"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{13, 10}, {8, 8}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12}],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {5, 5}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 6},
  CounterIncrements->"SmallText",
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{13, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {2, 2}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{5, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->RGBColor[1, 0.700008, 0.4]],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{62, Inherited}, {10, 10}},
  LineSpacing->{1, 0}],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {4, 4}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{44, 0}, {6, 6}},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{62, Inherited}, {12, 5}},
  LineSpacing->{1, 0}],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{40, Inherited}, {4, 1}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{44, 0}, {6, 2}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Graphics", "Condensed"],
  CellMargins->{{52, Inherited}, {Inherited, Inherited}},
  ImageSize->{175, 175}],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->11,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->8],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {2, 10}},
  FontSize->16,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
  CellMargins->{{12, 10}, {2, 12}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12},
  FontSize->20],

Cell[StyleData["Author", "Condensed"],
  CellMargins->{{8, 10}, {1, 4}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4},
  FontSize->12],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{9, 0}, {4, 12}},
  ParagraphSpacing->{0, 6},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Copyright"],
  ShowCellBracket->False,
  CellMargins->{{10, 10}, {40, 2}},
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Copyright", "Presentation"],
  CellMargins->{{12, 10}, {50, 2}},
  LineSpacing->{1, 5},
  FontSize->12],

Cell[StyleData["Copyright", "Condensed"],
  CellMargins->{{8, 10}, {12, 1}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["Copyright", "Printout"],
  CellMargins->{{9, 0}, {72, 4}},
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Example"],
  CellMargins->{{12, 10}, {5, 12}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  CounterIncrements->"Example",
  FontFamily->"Times",
  FontWeight->"Bold"],

Cell[StyleData["Example", "Presentation"],
  CellMargins->{{18, 10}, {8, 20}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12}],

Cell[StyleData["Example", "Condensed"],
  CellMargins->{{8, 10}, {4, 8}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["Example", "Printout"],
  CellMargins->{{9, 0}, {4, 10}},
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Definition"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  ShowStringCharacters->True,
  CounterIncrements->"Definition",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.700008, 0.700008]],

Cell[StyleData["Definition", "Presentation"],
  CellMargins->{{62, Inherited}, {5, 12}},
  LineSpacing->{1, 0}],

Cell[StyleData["Definition", "Condensed"],
  CellMargins->{{40, 10}, {1, 4}}],

Cell[StyleData["Definition", "Printout"],
  CellMargins->{{44, 0}, {2, 6}},
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  ShowStringCharacters->True,
  CounterIncrements->"Theorem",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Theorem", "Presentation"],
  CellMargins->{{62, Inherited}, {5, 12}},
  LineSpacing->{1, 0}],

Cell[StyleData["Theorem", "Condensed"],
  CellMargins->{{40, 10}, {1, 4}}],

Cell[StyleData["Theorem", "Printout"],
  CellMargins->{{44, 0}, {2, 6}},
  Background->GrayLevel[0.4]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExerciseMain"],
  CellFrame->{{6, 0}, {0, 1}},
  CellMargins->{{12, Inherited}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.571389, 0.19675, 0.570504],
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["ExerciseMain", "Presentation"],
  CellMargins->{{18, 10}, {8, 32}},
  LineSpacing->{1, 2},
  FontSize->24,
  FontTracking->"Condensed"],

Cell[StyleData["ExerciseMain", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["ExerciseMain", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  CellFrameColor->GrayLevel[0.500008],
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Exercise"],
  CellDingbat->"\[FilledDownTriangle]",
  CellMargins->{{23, Inherited}, {4, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Exercise", "Presentation"],
  CellMargins->{{33, 10}, {8, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Exercise", "Condensed"],
  CellMargins->{{17, Inherited}, {2, 12}},
  FontSize->10],

Cell[StyleData["Exercise", "Printout"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellDingbat->None,
  CellMargins->{{9, 0}, {6, 20}},
  FontSize->11,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExerciseText"],
  CellMargins->{{62, 10}, {5, 5}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"ExcersiceText",
  FontFamily->"Times"],

Cell[StyleData["ExerciseText", "Presentation"],
  CellMargins->{{74, 10}, {8, 8}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12}],

Cell[StyleData["ExerciseText", "Condensed"],
  CellMargins->{{52, 10}, {2, 2}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["ExerciseText", "Printout"],
  CellMargins->{{54, 0}, {4, 4}},
  ParagraphSpacing->{0, 6}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{62, 10}, {2, 10}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  CellMargins->{{74, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["DisplayFormula", "Condensed"],
  CellMargins->{{52, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{54, 10}, {2, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{62, 10}, {2, 10}},
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
  CellMargins->{{74, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["ChemicalFormula", "Condensed"],
  CellMargins->{{52, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{54, 10}, {2, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{12, 10}, {Inherited, 6}},
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{13, 30}, {Inherited, 4}},
  FontSize->9.5],

Cell[StyleData["Program", "Condensed"],
  CellMargins->{{8, 10}, {Inherited, 4}},
  FontSize->9.5],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{9, 0}, {Inherited, 4}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{62, 10}, {Inherited, Inherited}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
  CellMargins->{{74, 10}, {Inherited, Inherited}}],

Cell[StyleData["NumberedEquation", "Condensed"],
  CellMargins->{{52, 10}, {Inherited, Inherited}}],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{54, 0}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{62, 145}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}]], None}},
  CounterIncrements->"NumberedFigure",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Presentation"]],

Cell[StyleData["NumberedFigure", "Condensed"]],

Cell[StyleData["NumberedFigure", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{62, 145}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}]], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Presentation"]],

Cell[StyleData["NumberedTable", "Condensed"]],

Cell[StyleData["NumberedTable", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[1, 0.4, 0],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{481, 316},
WindowMargins->{{11, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 99, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2216, 72, 158, 5, 70, 33, 0, "StyleData", "All", "Condensed"],
Cell[2377, 79, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2554, 88, 35, 0, 30, "Section"],
Cell[2592, 90, 101, 3, 30, "Text"],
Cell[2696, 95, 529, 14, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3262, 114, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3325, 118, 373, 10, 66, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3701, 130, 112, 3, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3816, 135, 86, 2, 70, 37, 0, "StyleData", "Title", "Condensed"],
Cell[3905, 139, 138, 4, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4080, 148, 409, 12, 62, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4492, 162, 140, 4, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4635, 168, 113, 3, 70, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4751, 173, 142, 4, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4930, 182, 291, 8, 73, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5224, 192, 121, 3, 70, 46, 0, "StyleData", "Subsubtitle", 
"Presentation"],
Cell[5348, 197, 94, 2, 70, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[5445, 201, 94, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5576, 208, 429, 12, 55, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[6008, 222, 146, 4, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[6157, 228, 97, 2, 70, 39, 0, "StyleData", "Section", "Condensed"],
Cell[6257, 232, 140, 4, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6434, 241, 289, 8, 49, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6726, 251, 120, 3, 70, 45, 0, "StyleData", "Subsection", "Presentation"],

Cell[6849, 256, 100, 2, 70, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[6952, 260, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7080, 267, 279, 8, 49, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[7362, 277, 123, 3, 70, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[7488, 282, 104, 2, 70, 45, 0, "StyleData", "Subsubsection", "Condensed"],

Cell[7595, 286, 95, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7739, 294, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[7803, 298, 162, 5, 38, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[7968, 305, 126, 3, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[8097, 310, 121, 3, 70, 36, 0, "StyleData", "Text", "Condensed"],
Cell[8221, 315, 96, 2, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8354, 322, 190, 6, 43, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[8547, 330, 118, 3, 70, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[8668, 335, 113, 3, 70, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[8784, 340, 88, 2, 70, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8921, 348, 42, 0, 30, "Section"],
Cell[8966, 350, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[9239, 359, 516, 15, 61, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[9758, 376, 107, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[9868, 380, 72, 1, 70, 37, 0, "StyleData", "Input", "Condensed"],
Cell[9943, 383, 100, 2, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[10058, 388, 375, 12, 37, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[10458, 404, 508, 14, 60, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[10969, 420, 107, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[11079, 424, 80, 1, 70, 38, 0, "StyleData", "Output", "Condensed"],
Cell[11162, 427, 106, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11305, 434, 415, 12, 36, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[11723, 448, 123, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[11849, 452, 97, 1, 70, 39, 0, "StyleData", "Message", "Condensed"],
Cell[11949, 455, 123, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12109, 462, 412, 12, 36, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[12524, 476, 121, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[12648, 480, 95, 1, 70, 37, 0, "StyleData", "Print", "Condensed"],
Cell[12746, 483, 94, 1, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12877, 489, 389, 11, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[13269, 502, 101, 1, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[13373, 505, 123, 2, 70, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[13499, 509, 122, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13658, 516, 171, 5, 35, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13832, 523, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[13895, 526, 56, 1, 70, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[13954, 529, 82, 2, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14085, 537, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[14142, 541, 125, 4, 44, 25, 0, "StyleData", "Author", "All"],
Cell[14270, 547, 145, 4, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[14418, 553, 139, 4, 70, 38, 0, "StyleData", "Author", "Condensed"],
Cell[14560, 559, 115, 3, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14712, 567, 132, 4, 78, 28, 0, "StyleData", "Copyright", "All"],
Cell[14847, 573, 119, 3, 70, 44, 0, "StyleData", "Copyright", "Presentation"],

Cell[14969, 578, 114, 3, 70, 41, 0, "StyleData", "Copyright", "Condensed"],
Cell[15086, 583, 89, 2, 70, 40, 0, "StyleData", "Copyright", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15212, 590, 191, 6, 46, 26, 0, "StyleData", "Example", "All",
  CounterIncrements->"Example"],
Cell[15406, 598, 130, 3, 70, 42, 0, "StyleData", "Example", "Presentation"],
Cell[15539, 603, 124, 3, 70, 39, 0, "StyleData", "Example", "Condensed"],
Cell[15666, 608, 100, 2, 70, 38, 0, "StyleData", "Example", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15803, 615, 405, 11, 65, 29, 0, "StyleData", "Definition", "All",
  CounterIncrements->"Definition"],
Cell[16211, 628, 111, 2, 70, 45, 0, "StyleData", "Definition", 
"Presentation"],
Cell[16325, 632, 77, 1, 70, 42, 0, "StyleData", "Definition", "Condensed"],
Cell[16405, 635, 105, 2, 70, 41, 0, "StyleData", "Definition", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16547, 642, 403, 11, 65, 26, 0, "StyleData", "Theorem", "All",
  CounterIncrements->"Theorem"],
Cell[16953, 655, 108, 2, 70, 42, 0, "StyleData", "Theorem", "Presentation"],
Cell[17064, 659, 74, 1, 70, 39, 0, "StyleData", "Theorem", "Condensed"],
Cell[17141, 662, 102, 2, 70, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17280, 669, 431, 11, 57, 31, 0, "StyleData", "ExerciseMain", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[17714, 682, 151, 4, 70, 47, 0, "StyleData", "ExerciseMain", 
"Presentation"],
Cell[17868, 688, 102, 2, 70, 44, 0, "StyleData", "ExerciseMain", "Condensed"],

Cell[17973, 692, 184, 5, 70, 43, 0, "StyleData", "ExerciseMain", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18194, 702, 332, 9, 45, 27, 0, "StyleData", "Exercise", "All",
  CounterIncrements->"Subsubsection"],
Cell[18529, 713, 118, 3, 70, 43, 0, "StyleData", "Exercise", "Presentation"],
Cell[18650, 718, 99, 2, 70, 40, 0, "StyleData", "Exercise", "Condensed"],
Cell[18752, 722, 170, 5, 70, 39, 0, "StyleData", "Exercise", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18959, 732, 178, 5, 45, 31, 0, "StyleData", "ExerciseText", "All",
  CounterIncrements->"ExcersiceText"],
Cell[19140, 739, 134, 3, 70, 47, 0, "StyleData", "ExerciseText", 
"Presentation"],
Cell[19277, 744, 130, 3, 70, 44, 0, "StyleData", "ExerciseText", "Condensed"],

Cell[19410, 749, 105, 2, 70, 43, 0, "StyleData", "ExerciseText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19564, 757, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[19632, 761, 250, 6, 40, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[19885, 769, 101, 2, 70, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[19989, 773, 98, 2, 70, 46, 0, "StyleData", "DisplayFormula", 
"Condensed"],
Cell[20090, 777, 97, 2, 70, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20224, 784, 251, 7, 34, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[20478, 793, 102, 2, 39, 50, 0, "StyleData", "ChemicalFormula", 
"Presentation"],
Cell[20583, 797, 99, 2, 39, 47, 0, "StyleData", "ChemicalFormula", 
"Condensed"],
Cell[20685, 801, 98, 2, 39, 46, 0, "StyleData", "ChemicalFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[20820, 808, 94, 2, 36, 26, 0, "StyleData", "Program", "All"],
Cell[20917, 812, 102, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[21022, 816, 98, 2, 70, 39, 0, "StyleData", "Program", "Condensed"],
Cell[21123, 820, 96, 2, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21268, 828, 49, 0, 30, "Section"],
Cell[21320, 830, 225, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[21570, 838, 334, 7, 36, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[21907, 847, 102, 1, 70, 51, 0, "StyleData", "NumberedEquation", 
"Presentation"],
Cell[22012, 850, 99, 1, 70, 48, 0, "StyleData", "NumberedEquation", 
"Condensed"],
Cell[22114, 853, 97, 1, 70, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22248, 859, 336, 7, 64, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[22587, 868, 49, 0, 70, 49, 0, "StyleData", "NumberedFigure", 
"Presentation"],
Cell[22639, 870, 46, 0, 70, 46, 0, "StyleData", "NumberedFigure", 
"Condensed"],
Cell[22688, 872, 45, 0, 70, 45, 0, "StyleData", "NumberedFigure", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22770, 877, 306, 7, 64, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[23079, 886, 48, 0, 70, 48, 0, "StyleData", "NumberedTable", 
"Presentation"],
Cell[23130, 888, 45, 0, 70, 45, 0, "StyleData", "NumberedTable", "Condensed"],

Cell[23178, 890, 44, 0, 70, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23271, 896, 49, 0, 30, "Section"],
Cell[23323, 898, 149, 5, 32, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[23475, 905, 126, 4, 26, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[23604, 911, 152, 5, 33, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[23793, 921, 35, 0, 30, "Section"],
Cell[23831, 923, 184, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[24040, 931, 316, 9, 52, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[24359, 942, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[24406, 944, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[24450, 946, 95, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[24560, 951, 104, 3, 35, "Text"],

Cell[CellGroupData[{
Cell[24689, 958, 307, 8, 52, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[24999, 968, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[25049, 970, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[25096, 972, 98, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25231, 979, 328, 9, 60, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[25562, 990, 45, 0, 70, 45, 0, "StyleData", "AddOnsLink", "Presentation"],

Cell[25610, 992, 42, 0, 70, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[25655, 994, 95, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25787, 1001, 336, 9, 60, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[26126, 1012, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[26176, 1014, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],

Cell[26223, 1016, 98, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26358, 1023, 319, 8, 60, 37, 0, "StyleData", "GettingStartedLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[26680, 1033, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[26736, 1035, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[26789, 1037, 104, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26930, 1044, 323, 8, 60, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[27256, 1054, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[27314, 1056, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[27369, 1058, 106, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

